/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.Server;
import noppes.npcs.api.IPos;
import noppes.npcs.api.handler.IBorderHandler;
import noppes.npcs.api.handler.data.IBorder;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.data.Zone3D;

public class BorderController
implements IBorderHandler {
    private static BorderController instance;
    public final Map<Integer, Zone3D> regions = new TreeMap<Integer, Zone3D>();

    public static BorderController getInstance() {
        if (instance == null) {
            instance = new BorderController();
        }
        return instance;
    }

    public BorderController() {
        instance = this;
        this.load();
    }

    public Zone3D createNew(int dimensionID, BlockPos pos) {
        Zone3D reg = new Zone3D(this.getUnusedId(), dimensionID, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        this.regions.put(reg.getId(), reg);
        return reg;
    }

    @Override
    public IBorder createNew(int dimensionID, IPos pos) {
        return this.createNew(dimensionID, pos.getMCBlockPos());
    }

    @Override
    public IBorder[] getAllRegions() {
        return this.regions.values().toArray(new IBorder[0]);
    }

    public NBTTagCompound getNBT() {
        NBTTagList list = new NBTTagList();
        for (Zone3D region : this.regions.values()) {
            NBTTagCompound nbtRegion = new NBTTagCompound();
            region.save(nbtRegion);
            list.func_74742_a((NBTBase)nbtRegion);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74782_a("Data", (NBTBase)list);
        return nbttagcompound;
    }

    public int getRegionID(int dimensionID, BlockPos pos) {
        for (Zone3D reg : this.regions.values()) {
            if (!reg.contains(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dimensionID)) continue;
            return reg.getId();
        }
        return -1;
    }

    @Override
    public IBorder getRegion(int regionId) {
        return this.regions.get(regionId);
    }

    @Override
    public IBorder[] getRegions(int dimensionID) {
        ArrayList<Zone3D> regs = new ArrayList<Zone3D>();
        for (Zone3D reg : this.regions.values()) {
            if (reg.dimensionID != dimensionID) continue;
            regs.add(reg);
        }
        return regs.toArray(new IBorder[0]);
    }

    public List<Zone3D> getRegionsInWorld(int dimensionID) {
        ArrayList<Zone3D> regs = new ArrayList<Zone3D>();
        for (Zone3D reg : this.regions.values()) {
            if (reg.dimensionID != dimensionID) continue;
            regs.add(reg);
        }
        return regs;
    }

    @Override
    public List<Zone3D> getNearestRegions(int dimensionID, double xPos, double yPos, double zPos, double distance) {
        AxisAlignedBB searchBox = new AxisAlignedBB(xPos - distance, 0.0, zPos - distance, xPos + distance + 1.0, 255.0, zPos + distance + 1.0);
        ArrayList<Zone3D> regionsIn = new ArrayList<Zone3D>();
        for (Zone3D reg : this.regions.values()) {
            if (reg.dimensionID != dimensionID || !searchBox.func_72326_a(reg.getAxisAlignedBB())) continue;
            regionsIn.add(reg);
        }
        return regionsIn;
    }

    public int getUnusedId() {
        int id = 0;
        while (this.regions.containsKey(id)) {
            ++id;
        }
        return id;
    }

    public Zone3D loadRegion(NBTTagCompound nbtRegion) {
        if (nbtRegion == null || !nbtRegion.func_150297_b("ID", 3) || nbtRegion.func_74762_e("ID") < 0) {
            return null;
        }
        int id = nbtRegion.func_74762_e("ID");
        if (this.regions.containsKey(id)) {
            this.regions.get(id).load(nbtRegion);
            return this.regions.get(id);
        }
        Zone3D region = new Zone3D();
        region.load(nbtRegion);
        this.regions.put(region.getId(), region);
        return this.regions.get(region.getId());
    }

    private void load() {
        CustomNpcs.debugData.start(null);
        File saveDir = CustomNpcs.getWorldSaveDirectory();
        if (saveDir == null) {
            CustomNpcs.debugData.end(null);
            return;
        }
        try {
            File file = new File(saveDir, "borders.dat");
            if (file.exists()) {
                this.loadRegions(file);
            }
        }
        catch (Exception e) {
            try {
                File file2 = new File(saveDir, "borders.dat_old");
                if (file2.exists()) {
                    this.loadRegions(file2);
                }
            }
            catch (Exception ex) {
                LogWriter.error(ex);
            }
        }
        CustomNpcs.debugData.end(null);
    }

    private void loadRegions(File file) throws IOException {
        this.loadRegions(CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0])));
    }

    public void loadRegions(NBTTagCompound compound) {
        this.regions.clear();
        if (compound.func_150297_b("Data", 9)) {
            for (int i = 0; i < compound.func_150295_c("Data", 10).func_74745_c(); ++i) {
                this.loadRegion(compound.func_150295_c("Data", 10).func_150305_b(i));
            }
        }
    }

    @Override
    public boolean removeRegion(int region) {
        if (region < 0 || this.regions.isEmpty()) {
            return false;
        }
        this.regions.remove(region);
        this.save();
        return true;
    }

    public void save() {
        CustomNpcs.debugData.start(null);
        try {
            File saveDir = CustomNpcs.getWorldSaveDirectory();
            File file = new File(saveDir, "borders.dat_new");
            File file2 = new File(saveDir, "borders.dat_old");
            File file3 = new File(saveDir, "borders.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.getNBT(), (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file.renameTo(file3);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        CustomNpcs.debugData.end(null);
    }

    public void sendTo(EntityPlayerMP player) {
        Server.sendData(player, EnumPacketClient.BORDER_DATA, -1, new NBTTagCompound());
        for (int id : this.regions.keySet()) {
            if (id < 0 || this.regions.get(id).getId() < 0) continue;
            NBTTagCompound nbtRegion = new NBTTagCompound();
            this.regions.get(id).save(nbtRegion);
            Server.sendDataDelayed(player, EnumPacketClient.BORDER_DATA, 10, id, nbtRegion);
        }
        Server.sendDataDelayed(player, EnumPacketClient.BORDER_DATA, 10, -2);
    }

    public void update() {
        if (CustomNpcs.Server == null || CustomNpcs.Server.func_184103_al().func_72369_d().length == 0 || this.regions.isEmpty()) {
            return;
        }
        for (Zone3D reg : this.regions.values()) {
            for (WorldServer w : CustomNpcs.Server.field_71305_c) {
                reg.update(w);
            }
        }
    }

    public void update(int id) {
        block5: {
            block4: {
                if (CustomNpcs.Server == null || CustomNpcs.Server.func_184103_al().func_72369_d().length == 0) {
                    return;
                }
                if (id >= 0) break block4;
                for (int i : this.regions.keySet()) {
                    NBTTagCompound nbtRegion = new NBTTagCompound();
                    this.regions.get(i).save(nbtRegion);
                    for (EntityPlayerMP player : CustomNpcs.Server.func_184103_al().func_181057_v()) {
                        Server.sendDataDelayed(player, EnumPacketClient.BORDER_DATA, 10, i, nbtRegion);
                        Server.sendDataDelayed(player, EnumPacketClient.BORDER_DATA, 10, -2);
                    }
                }
                break block5;
            }
            if (!this.regions.containsKey(id)) break block5;
            NBTTagCompound nbtRegion = new NBTTagCompound();
            this.regions.get(id).save(nbtRegion);
            for (EntityPlayerMP player : CustomNpcs.Server.func_184103_al().func_181057_v()) {
                Server.sendDataDelayed(player, EnumPacketClient.BORDER_DATA, 10, id, nbtRegion);
                Server.sendDataDelayed(player, EnumPacketClient.BORDER_DATA, 10, -2);
            }
        }
    }
}

